#!%perl%

#########################################################
#            AVSMaker Professional Edition              #
#     Written entirely by Dan Jones (sf@termina.com)    #
#########################################################
#                                                       #
#                                                       #
# This script was created by:                           #
#                                                       #
# PerlCoders Web Specialties PTY.                       #
# http://www.perlcoders.com                             #
#                                                       #
# This script and all included modules, lists or        #
# images, documentation are copyright only to           #
# PerlCoders PTY (http://perlcoders.com) unless         #
# otherwise stated in the module.                       #
#                                                       #
# Purchasers are granted rights to use this script      #
# on any site they own. There is no individual site     #
# license needed per site.                              #
#                                                       #
# Any copying, distribution, modification with          #
# intent to distribute as new code will result          #
# in immediate loss of your rights to use this          #
# program as well as possible legal action.             #
#                                                       #
# This and many other fine scripts are available at     #
# the above website or by emailing the authors at       #
# staff@perlcoders.com or info@perlcoders.com           #
#                                                       #
#                                                       #
#########################################################

#########################################################
#                                                       #
#  Controls scheduled and automated script runs         #
#                                                       #
#  Should not be run manually                           #
#                                                       #
#########################################################



my $crontab = "/usr/bin/crontab";

#$cf{datapath} = "/path/to/avspro";



#-------------------------! do not edit below here !---------------------------

use strict;
use vars qw(%cf %used @cats);
$cf{datapath} = $ENV{PWD} || `pwd` or die "Could not find datapath, please set in scheduler.pl";
chomp $cf{datapath};
use Getopt::Std;
err("Bad crontab path $crontab, please alter in scheduler.pl")
	if !-x $crontab;
require "$cf{datapath}/routines.pl" or
	err("Could not find file routines.pl, check directory is set correctly");

my (
	%o,
);

getopts("rgs:c:m:", \%o);
readconf();

# opts:
#  -r	- execute last crontab entry
#  -g	- generate linksites
#  -s	- number of sites to generate
#  -c	- niche
#  -m	- modules to run for

if ($o{r}) {
	# execute programs
	my @ctab = grep { !/scheduler.pl\ -r/ } qx($crontab -l);
	open (TMP, "> /tmp/ap.crontab")
		or err("Could not write to /tmp?");
	print TMP join("", @ctab);
	close TMP;
	system("crontab /tmp/ap.crontab");
	unlink "/tmp/ap.crontab";
	err("Could not find avspro.pl, check directory is set correctly")
		if !-x "./avspro.pl";
	system("./avspro.pl " .
		($o{s} ? "-s $o{s} " : "") .
		($o{c} ? "-c $o{c} " : "") .
		($o{m} ? "-m $o{m} " : "") .
		($o{g} ? "-g" : "").
		($cf{quietsched} ? "-q" : ""));
} else {
	# add to crontab if found in scheduler
	my ($hour, $wday) = (localtime)[2,6];
	my $ac = dosql(qq[select * from ap_schedule where hr = "$hour" and runs > 0]);
	while (my $row = $ac->fetchrow_hashref) {
		my $mods = join(",", @$row{"mod_1", "mod_2", "mod_3", "mod_4", "mod_5"});
		$mods =~ s/,{2,}/,/g; $mods =~ s/^,//; $mods =~ s/,$//;
		my $min = int(rand(59)) + 1;
		my $ctab = join("", qx($crontab -l));
		warn "No crontab output, possible error?" if !$ctab;
		$ctab .= "$min $hour * * * cd $ENV{PWD} && ./scheduler.pl -r -s $$row{runs} " .
			($mods =~ /,/ ? "-m $mods " : "") .
			($$row{cat} ? "-c $$row{cat} " : "") .
			($$row{genlinksite} ? "-g " : "");
		$ctab =~ s/\s+$//;
		open (TMP, "> /tmp/ap.crontab")
			or err("Could not write to /tmp?");
		print TMP "$ctab\n";
		close TMP;
		system("crontab /tmp/ap.crontab");
		unlink "/tmp/ap.crontab";
	}
	if ("$wday$hour" eq $cf{lsgtime}) {
		# regenerate central linksite
		system("./avspro.pl -a".
			($cf{quietsched} ? " -q" : ""));
	}
	if ($hour == 0) {
		# update script
		print "yea!\n";
		system("./avspro.pl -u" .
			($cf{quietsched} ? " -q" : ""));
	}
}

sub	err {
	print "ERROR:\n\n * $_[0]\n";
	exit;
}
